/*
 * Decompiled with CFR 0.152.
 */
package TCPIP_Discoverer;

import com.sun.java.swing.plaf.windows.WindowsLookAndFeel;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.apache.commons.net.tftp.TFTPClient;

public class TCPIPDiscovererTool
extends JFrame {
    public static DatagramSocket socket;
    public static DatagramPacket packet;
    public static DefaultTableModel model;
    public static Thread recvThread;
    public static Thread manageTable;
    public static String mchipUrl;
    String str = "Discover GCE Devices";
    String received = " ";
    long threadSleep = 500L;
    ReentrantLock lock = new ReentrantLock();
    ImageIcon icon = new ImageIcon(this.getClass().getResource("/Resource/gcelogo.jpg"));
    public TFTPClient tftp = new TFTPClient();
    public int transferMode = 0;
    public final JPanel panel = new JPanel();
    private String boundary;
    public boolean isConfigDownloaded;
    public int etape;
    private JButton btnDiscover;
    private JButton btnExit;
    private JButton btnFlash;
    private JLabel jLabel1;
    private JProgressBar jProgressBar1;
    private JScrollPane jScrollPane1;
    private JTable jTable1;

    static {
        recvThread = null;
        manageTable = null;
    }

    public TCPIPDiscovererTool() {
        this.initComponents();
        this.changeTableColumnWidth();
        this.setIconImage(this.icon.getImage());
        this.udpAction();
        UIManager.put("Button.defaultButtonFollowsFocus", Boolean.TRUE);
        this.setLocation(200, 150);
        this.jLabel1.setVisible(false);
    }

    public void addDiscoveryEntry(String receivePacket) {
        Object[] s = receivePacket.split("\n");
        model = (DefaultTableModel)this.jTable1.getModel();
        int rowCnt = model.getRowCount();
        int index = 0;
        while (index < rowCnt) {
            String macAddrs = (String)model.getValueAt(index, 2);
            if (!macAddrs.isEmpty() && ((String)s[2]).contentEquals(macAddrs)) {
                model.removeRow(index);
                model.insertRow(index, s);
                if (((String)s[3]).contains("DHCP/Power event occurred")) {
                    model.setValueAt("", index, 3);
                    model.setValueAt(s[3], index, 5);
                }
                return;
            }
            ++index;
        }
        model.insertRow(0, s);
    }

    public void receiveUDPPacket() {
        try {
            byte[] buf = new byte[100];
            int i = 0;
            while (i < buf.length) {
                buf[i] = 32;
                ++i;
            }
            packet = new DatagramPacket(buf, buf.length);
            socket.receive(packet);
            this.received = new String(packet.getData());
            while (true) {
                i = 0;
                while (i < buf.length) {
                    buf[i] = 32;
                    ++i;
                }
                packet = new DatagramPacket(buf, buf.length);
                try {
                    socket.receive(packet);
                }
                catch (SocketTimeoutException socketTimeoutException) {
                    // empty catch block
                }
                if (new String(packet.getData()).trim().length() == 0 || packet.getLength() < 36) continue;
                this.received = new String(packet.getData());
                if (this.received.isEmpty()) continue;
                this.lock.lock();
                this.received = String.valueOf(packet.getAddress().getHostAddress()) + "\n" + this.received.replace("\r\n", "\n");
                this.addDiscoveryEntry(this.received);
                this.received = " ";
                this.lock.unlock();
            }
        }
        catch (IOException e) {
            this.close_action();
            return;
        }
    }

    public void udpAction() {
        try {
            recvThread = new Thread(){

                @Override
                public void run() {
                    TCPIPDiscovererTool.this.receiveUDPPacket();
                }
            };
            manageTable = new Thread(){

                @Override
                public void run() {
                    while (true) {
                        if (TCPIPDiscovererTool.this.received.trim().isEmpty() || TCPIPDiscovererTool.this.received.isEmpty()) {
                            continue;
                        }
                        String[] s = TCPIPDiscovererTool.this.received.split("\n");
                        if (s[1].trim().isEmpty()) {
                            TCPIPDiscovererTool.this.received = " ";
                            continue;
                        }
                        TCPIPDiscovererTool.this.lock.lock();
                        TCPIPDiscovererTool.this.addDiscoveryEntry(TCPIPDiscovererTool.this.received);
                        TCPIPDiscovererTool.this.received = " ";
                        TCPIPDiscovererTool.this.lock.unlock();
                    }
                }
            };
            socket = new DatagramSocket(30303);
            socket.setBroadcast(true);
            InetAddress address = InetAddress.getByName("255.255.255.255");
            packet = new DatagramPacket(this.str.getBytes(), this.str.length(), address, 30303);
            socket.send(packet);
            recvThread.start();
        }
        catch (IOException e) {
            String optionStr = "<html>Unable to transmit discovery message. <br> Check network connectivity and ensure that no other instances of this program are running.";
            JOptionPane.showMessageDialog(null, optionStr, "Error", 0);
            this.close_action();
        }
    }

    private void initComponents() {
        this.btnExit = new JButton();
        this.btnDiscover = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.jTable1 = new JTable();
        this.btnFlash = new JButton();
        this.jProgressBar1 = new JProgressBar();
        this.jLabel1 = new JLabel();
        this.setDefaultCloseOperation(3);
        this.setTitle("GCE Electronics Scan Devices");
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                TCPIPDiscovererTool.this.formWindowClosing(evt);
            }
        });
        this.btnExit.setText("Exit");
        this.btnExit.setMaximumSize(new Dimension(115, 23));
        this.btnExit.setMinimumSize(new Dimension(115, 23));
        this.btnExit.setPreferredSize(new Dimension(115, 23));
        this.btnExit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TCPIPDiscovererTool.this.btnExitActionPerformed(evt);
            }
        });
        this.btnDiscover.setText("Scan Devices");
        this.btnDiscover.setCursor(new Cursor(0));
        this.btnDiscover.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TCPIPDiscovererTool.this.btnDiscoverActionPerformed(evt);
            }
        });
        this.jTable1.setModel(new DefaultTableModel(new Object[0][], new String[]{"IP Address", "Host Name", "MAC Address", "Port", "Product", "Other Info"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{String.class, String.class, String.class, String.class, String.class, String.class};
                this.canEdit = new boolean[6];
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.jTable1.setCursor(new Cursor(0));
        this.jTable1.setSelectionMode(0);
        this.jTable1.getTableHeader().setReorderingAllowed(false);
        this.jTable1.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                TCPIPDiscovererTool.this.jTable1MouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jTable1);
        this.btnFlash.setText("Flash Device");
        this.btnFlash.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                TCPIPDiscovererTool.this.btnFlashLMouseClicked(evt);
            }
        });
        this.jLabel1.setText("jLabel1");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.btnDiscover, -2, 150, -2).addGap(18, 18, 18).addComponent(this.btnFlash, -2, 150, -2).addGap(0, 0, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.jProgressBar1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 296, Short.MAX_VALUE).addComponent(this.btnExit, -2, 150, -2))).addContainerGap()).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 630, Short.MAX_VALUE).addContainerGap())));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnFlash, -2, 28, -2).addComponent(this.btnDiscover, -2, 28, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 300, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.btnExit, GroupLayout.Alignment.TRAILING, -2, 28, -2).addComponent(this.jProgressBar1, GroupLayout.Alignment.TRAILING, -2, -1, -2).addComponent(this.jLabel1, GroupLayout.Alignment.TRAILING)).addGap(13, 13, 13)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(49, 49, 49).addComponent(this.jScrollPane1, -2, 277, -2).addContainerGap(54, Short.MAX_VALUE))));
        this.pack();
    }

    private void btnExitActionPerformed(ActionEvent evt) {
        System.exit(0);
    }

    private void btnDiscoverActionPerformed(ActionEvent evt) {
        try {
            if (!socket.isBound()) {
                socket = new DatagramSocket(30303);
                System.out.println("EthDiscoverActionPerformed:after socket");
            }
            InetAddress address = InetAddress.getByName("255.255.255.255");
            model = (DefaultTableModel)this.jTable1.getModel();
            int rowcount = model.getRowCount();
            int index1 = 0;
            while (index1 < rowcount) {
                model.removeRow(0);
                ++index1;
            }
            packet = new DatagramPacket(this.str.getBytes(), this.str.length(), address, 30303);
            socket.send(packet);
            this.jTable1.addMouseListener(null);
        }
        catch (IOException soEx) {
            String optionStr = "<html>Unable to transmit discovery message. <br> Check network connectivity and ensure that no other instances of this program are running.";
            JOptionPane.showMessageDialog(null, optionStr, "Error", 0);
            this.close_action();
        }
    }

    private void jTable1MouseClicked(MouseEvent evt) {
        if (evt.getClickCount() == 2) {
            Point pt = evt.getPoint();
            int row = this.jTable1.rowAtPoint(pt);
            int col = this.jTable1.columnAtPoint(pt);
            String url = (String)this.jTable1.getValueAt(row, 0);
            url = model.getValueAt(row, 3).toString().isEmpty() ? String.valueOf((String)this.jTable1.getValueAt(row, 0)) + ":80" : String.valueOf((String)this.jTable1.getValueAt(row, 0)) + ":" + (String)this.jTable1.getValueAt(row, 3);
            mchipUrl = "http://" + url;
            try {
                URL myUrl = new URL(mchipUrl);
                Desktop.getDesktop().browse(myUrl.toURI());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void btnFlashLMouseClicked(MouseEvent evt) {
        int ret;
        String fwstrbin;
        String fwstrhex;
        String macAddr;
        if (!this.getEnableButton()) {
            return;
        }
        this.setEnableButton(false);
        this.etape = 0;
        this.isConfigDownloaded = false;
        JFileChooser choix = new JFileChooser();
        try {
            int row = this.jTable1.getSelectedRow();
            String hostname = (String)this.jTable1.getValueAt(row, 0);
            macAddr = (String)this.jTable1.getValueAt(row, 2);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this.panel, "Veuillez s\u00e9lectionner l'appareil que vous voulez flasher", "ERROR", 0);
            this.setEnableButton(true);
            return;
        }
        String path = System.getProperty("user.dir");
        String fwdirstr = path.concat("//Firmware");
        File fwdir = new File(fwdirstr);
        if (!fwdir.exists()) {
            fwdir.mkdir();
        }
        String[] fwstr = fwdir.list();
        File[] subfiles = fwdir.listFiles();
        int i = 0;
        while (i < fwstr.length) {
            System.out.println(subfiles[i]);
            if (subfiles[i].isHidden()) {
                subfiles[i].delete();
            }
            ++i;
        }
        fwstr = fwdir.list();
        if (fwstr.length == 0) {
            JOptionPane.showMessageDialog(this.panel, "Veuillez copier dans le r\u00e9pertoire " + fwdirstr + " les fichiers .hex and .bin que vous avez t\u00e9l\u00e9charg\u00e9", "ERROR", 0);
            this.setEnableButton(true);
            return;
        }
        if (fwstr.length == 1) {
            if (fwstr[0].contains(".hex")) {
                JOptionPane.showMessageDialog(this.panel, "Il manque un fichier .bin dans le r\u00e9pertoire " + fwdirstr, "ERROR", 0);
            }
            if (fwstr[0].contains(".bin")) {
                JOptionPane.showMessageDialog(this.panel, "Il manque un fichier .hex dans le r\u00e9pertoire " + fwdirstr, "ERROR", 0);
            } else {
                JOptionPane.showMessageDialog(this.panel, "Veuillez supprimer le fichier pr\u00e9sent dans le r\u00e9pertoire " + fwdirstr + "\nVeuillez ensuite copier les fichiers .hex and .bin que vous avez t\u00e9l\u00e9charg\u00e9", "ERROR", 0);
            }
            this.setEnableButton(true);
            return;
        }
        if (fwstr.length > 2) {
            JOptionPane.showMessageDialog(this.panel, "Il y a trop d'\u00e9l\u00e9ments dans le r\u00e9pertoire " + fwdirstr + "\nPour le bon fonctionnement, veuillez seulement copier les fichiers .hex and .bin que vous avez t\u00e9l\u00e9charg\u00e9", "ERROR", 0);
            this.setEnableButton(true);
            return;
        }
        if (fwstr[0].contains(".hex")) {
            fwstrhex = fwstr[0];
            fwstrbin = fwstr[1];
        } else {
            fwstrbin = fwstr[0];
            fwstrhex = fwstr[1];
        }
        String[] fwStrBinSplited = fwstrbin.split("\\p{Punct}");
        String[] fwStrHexSplited = fwstrhex.split("\\p{Punct}");
        if (!fwStrBinSplited[1].equals(fwStrHexSplited[1]) && (ret = JOptionPane.showConfirmDialog(this.panel, "Le deux firmwares ne correspondent pas a la m\u00eame version\nVoulez-vous continuer ?", "Warning", 2)) == 2) {
            this.setEnableButton(true);
            return;
        }
        final String localBinFilename = fwdirstr.concat("//" + fwstrbin);
        final String localHexFilename = fwdirstr.concat("//" + fwstrhex);
        final String remoteHexFilename = fwstrhex;
        new Thread(){

            @Override
            public void run() {
                try {
                    TCPIPDiscovererTool.this.jLabel1.setVisible(true);
                    TCPIPDiscovererTool.this.jLabel1.setText("Verification du fichier hex");
                    TCPIPDiscovererTool.this.jProgressBar1.setIndeterminate(true);
                    if (TCPIPDiscovererTool.this.checksum(localHexFilename) == -1) {
                        JOptionPane.showMessageDialog(TCPIPDiscovererTool.this.panel, "Le fichier .hex est corrompu, veuillez le changer", "Error", 0);
                        TCPIPDiscovererTool.this.setEnableButton(true);
                        return;
                    }
                    TCPIPDiscovererTool.this.jLabel1.setText("Fichier hex verfi\u00e9");
                    TCPIPDiscovererTool.this.jProgressBar1.setIndeterminate(false);
                    new Thread(){

                        @Override
                        public void run() {
                            TCPIPDiscovererTool.this.jLabel1.setVisible(true);
                            TCPIPDiscovererTool.this.jLabel1.setText("Envoi du firmware");
                            TCPIPDiscovererTool.this.jProgressBar1.setIndeterminate(true);
                            try {
                                int row = TCPIPDiscovererTool.this.jTable1.getSelectedRow();
                                String produit = (String)TCPIPDiscovererTool.this.jTable1.getValueAt(row, 4);
                                TCPIPDiscovererTool.this.Scanning();
                                if (produit.equals("IPX800 V4")) {
                                    System.out.println("C'est une V4 !!");
                                    TCPIPDiscovererTool.this.httpupload(TCPIPDiscovererTool.this.getIPbyMac(macAddr), localHexFilename, TCPIPDiscovererTool.this.getPortbyMac(macAddr));
                                    Thread.sleep(15000L);
                                } else {
                                    TCPIPDiscovererTool.this.tftpupload(TCPIPDiscovererTool.this.getIPbyMac(macAddr), localHexFilename, remoteHexFilename);
                                }
                            }
                            catch (InterruptedException ex) {
                                Logger.getLogger(TCPIPDiscovererTool.class.getName()).log(Level.SEVERE, null, ex);
                            }
                            new Thread(){

                                @Override
                                public void run() {
                                    TCPIPDiscovererTool.this.Scanning();
                                    try {
                                        Thread.sleep(7000L);
                                    }
                                    catch (InterruptedException e) {
                                        e.printStackTrace();
                                    }
                                    TCPIPDiscovererTool.this.jLabel1.setVisible(true);
                                    TCPIPDiscovererTool.this.jLabel1.setText("Chargement de site web");
                                    TCPIPDiscovererTool.this.jProgressBar1.setIndeterminate(true);
                                    try {
                                        TCPIPDiscovererTool.this.httpupload(TCPIPDiscovererTool.this.getIPbyMac(macAddr), localBinFilename, TCPIPDiscovererTool.this.getPortbyMac(macAddr));
                                    }
                                    catch (InterruptedException ex) {
                                        Logger.getLogger(TCPIPDiscovererTool.class.getName()).log(Level.SEVERE, null, ex);
                                    }
                                    TCPIPDiscovererTool.this.jLabel1.setVisible(true);
                                    TCPIPDiscovererTool.this.jLabel1.setText("site web charg\u00e9");
                                    TCPIPDiscovererTool.this.jProgressBar1.setIndeterminate(false);
                                    TCPIPDiscovererTool.this.jLabel1.setVisible(true);
                                    TCPIPDiscovererTool.this.jLabel1.setText("HardReset en cours");
                                    TCPIPDiscovererTool.this.jProgressBar1.setIndeterminate(true);
                                    try {
                                        TCPIPDiscovererTool.this.sendReboot(TCPIPDiscovererTool.this.getIPbyMac(macAddr), 'H');
                                        String addrMac = "Vide";
                                        int i = 0;
                                        while (i < TCPIPDiscovererTool.this.jTable1.getRowCount()) {
                                            addrMac = (String)TCPIPDiscovererTool.this.jTable1.getValueAt(i, 2);
                                            if (!addrMac.equals(macAddr)) {
                                                System.out.println("Diff\u00e9rent");
                                            }
                                            ++i;
                                        }
                                    }
                                    catch (Exception ex) {
                                        Logger.getLogger(TCPIPDiscovererTool.class.getName()).log(Level.SEVERE, null, ex);
                                    }
                                    TCPIPDiscovererTool.this.jProgressBar1.setIndeterminate(false);
                                    new Thread(){

                                        @Override
                                        public void run() {
                                            try {
                                                TCPIPDiscovererTool.this.jProgressBar1.setIndeterminate(true);
                                                TCPIPDiscovererTool.this.sendReboot(TCPIPDiscovererTool.this.getIPbyMac(macAddr), 'R');
                                                TCPIPDiscovererTool.this.jLabel1.setText("Attendez");
                                            }
                                            catch (Exception ex) {
                                                Logger.getLogger(TCPIPDiscovererTool.class.getName()).log(Level.SEVERE, null, ex);
                                            }
                                            try {
                                                Thread.sleep(6000L);
                                                TCPIPDiscovererTool.this.Scanning();
                                                TCPIPDiscovererTool.this.jProgressBar1.setIndeterminate(false);
                                                TCPIPDiscovererTool.this.setEnableButton(true);
                                                TCPIPDiscovererTool.this.jLabel1.setVisible(false);
                                            }
                                            catch (InterruptedException ex) {
                                                Logger.getLogger(TCPIPDiscovererTool.class.getName()).log(Level.SEVERE, null, ex);
                                            }
                                        }
                                    }.start();
                                }
                            }.start();
                        }
                    }.start();
                }
                catch (FileNotFoundException ex) {
                    Logger.getLogger(TCPIPDiscovererTool.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (IOException ex) {
                    Logger.getLogger(TCPIPDiscovererTool.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }.start();
    }

    private void formWindowClosing(WindowEvent evt) {
        this.setDefaultCloseOperation(3);
    }

    public void close_action() {
        if (socket != null && socket.isConnected()) {
            socket.close();
        }
        if (recvThread != null && recvThread.isAlive()) {
            recvThread = null;
        }
        if (manageTable != null && manageTable.isAlive()) {
            manageTable = null;
        }
    }

    void changeTableColumnWidth() {
        TableColumn column = null;
        final TableCellRenderer tcr = this.jTable1.getTableHeader().getDefaultRenderer();
        this.jTable1.getTableHeader().setDefaultRenderer(new TableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                JLabel lbl = (JLabel)tcr.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                lbl.setBorder(BorderFactory.createCompoundBorder(lbl.getBorder(), BorderFactory.createEmptyBorder(0, 5, 0, 0)));
                lbl.setHorizontalAlignment(2);
                return lbl;
            }
        });
        this.jTable1.setAutoResizeMode(4);
        this.jTable1.setDragEnabled(false);
        this.jTable1.setColumnSelectionAllowed(false);
        int colNumber = this.jTable1.getColumnCount();
        int i = 0;
        while (i < colNumber) {
            column = this.jTable1.getColumnModel().getColumn(i);
            switch (i) {
                case 0: {
                    column.setPreferredWidth(100);
                    column.setMaxWidth(120);
                    break;
                }
                case 1: {
                    column.setPreferredWidth(100);
                    column.setMaxWidth(120);
                    break;
                }
                case 2: {
                    column.setPreferredWidth(130);
                    column.setMaxWidth(180);
                    break;
                }
                case 3: {
                    column.setPreferredWidth(40);
                    column.setMaxWidth(60);
                    break;
                }
                case 4: {
                    column.setPreferredWidth(140);
                    column.setMaxWidth(400);
                }
            }
            column.setResizable(true);
            ++i;
        }
    }

    public void sendReboot(String ipAddress, char option) throws Exception {
        try {
            byte[] sendR = new byte[]{(byte)option};
            DatagramSocket clientSocket = new DatagramSocket();
            DatagramPacket sendPacket = new DatagramPacket(sendR, sendR.length, InetAddress.getByName(ipAddress), 69);
            clientSocket.send(sendPacket);
            clientSocket.close();
        }
        catch (UnknownHostException ex) {
            System.err.println(ex);
        }
        catch (IOException ex) {
            System.err.println(ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int checksum(String path) throws FileNotFoundException, IOException {
        int nbdata = 0;
        int address = 0;
        int type = 0;
        int chk = 0;
        int[] codehex = new int[64];
        int ctrlChk = 0;
        BufferedReader buff = new BufferedReader(new FileReader(path));
        try {
            String str;
            block2: while ((str = buff.readLine()) != null) {
                if (str.charAt(0) != ':') {
                    buff.close();
                    return -1;
                }
                ctrlChk = nbdata = Integer.parseInt(str.substring(1, 3), 16);
                address = Integer.parseInt(str.substring(3, 7), 16);
                ctrlChk += address;
                type = Integer.parseInt(str.substring(7, 9), 16);
                ctrlChk += type;
                int j = 0;
                int i = 0;
                while (true) {
                    if (i >= nbdata) {
                        chk = Integer.parseInt(str.substring(j + 2, j + 4), 16);
                        continue block2;
                    }
                    j = 9 + i * 2;
                    codehex[i] = Integer.parseInt(str.substring(j, j + 2), 16);
                    ctrlChk += codehex[i];
                    ++i;
                }
            }
        }
        catch (Exception e) {
            buff.close();
            return -1;
        }
        buff.close();
        return 0;
    }

    void tftpupload(String hostname, String filename, String remotename) {
        try {
            this.sendReboot(hostname, 'R');
        }
        catch (Exception ex) {
            Logger.getLogger(TCPIPDiscovererTool.class.getName()).log(Level.SEVERE, null, ex);
        }
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException ex) {
            Logger.getLogger(TCPIPDiscovererTool.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.tftp = new TFTPClient();
        this.tftp.setDefaultTimeout(60000);
        try {
            System.out.println("Ouverture");
            this.tftp.open();
            System.out.println("Fin ouverture");
        }
        catch (SocketException e) {
            System.err.println("Error: could not open local UDP socket.");
            System.err.println(e.getMessage());
            System.exit(1);
        }
        FileInputStream input = null;
        try {
            System.out.println("Ajout fichier");
            input = new FileInputStream(filename);
            System.out.println("Fin ajout");
        }
        catch (IOException e) {
            this.tftp.close();
            System.err.println("Error: could not open local file for reading.");
            System.err.println(e.getMessage());
            System.exit(1);
        }
        try {
            try {
                System.out.println("Envoie");
                System.out.println(remotename);
                System.out.println(this.transferMode);
                System.out.println(input);
                System.out.println(InetAddress.getByName(hostname));
                this.tftp.sendFile(remotename, this.transferMode, (InputStream)input, InetAddress.getByName(hostname));
                System.out.println("Fin envoie");
            }
            catch (UnknownHostException e) {
                System.err.println("Error: could not resolve hostname.");
                System.err.println(e.getMessage());
                System.exit(1);
                this.tftp.close();
                try {
                    input.close();
                }
                catch (IOException e2) {
                    System.err.println("Error: error closing file.");
                    System.err.println(e2.getMessage());
                }
            }
            catch (IOException e) {
                System.err.println("Error: I/O exception occurred while sending file.");
                System.err.println(e.getMessage());
                JOptionPane.showMessageDialog(this.panel, "Invalid .hex file", "ERROR", 0);
                try {
                    this.sendReboot(hostname, 'R');
                }
                catch (Exception ex) {
                    Logger.getLogger(TCPIPDiscovererTool.class.getName()).log(Level.SEVERE, null, ex);
                }
                this.tftp.close();
                try {
                    input.close();
                }
                catch (IOException e3) {
                    System.err.println("Error: error closing file.");
                    System.err.println(e3.getMessage());
                }
            }
        }
        finally {
            this.tftp.close();
            try {
                input.close();
            }
            catch (IOException e) {
                System.err.println("Error: error closing file.");
                System.err.println(e.getMessage());
            }
        }
    }

    void httpupload(String hostname, String filename, String port) {
        File imageFile = new File(filename);
        int uploadFileLength = (int)imageFile.length();
        String IPAddr = hostname;
        String PortAddr = port;
        String uploadPath = "fileupload";
        try {
            int byteRead;
            String urlPath = "http://" + IPAddr + ":" + PortAddr + "/" + uploadPath;
            int totalNumberOfBytes = 0;
            String initialBoundaryStr = String.valueOf(this.boundary) + "\r\n";
            String contentDisposition = "Content-Disposition: form-data; name=\"file\"; filename=\"" + imageFile.getName() + "\"\r\n";
            String contentType = "Content-Type: application/octet-stream\r\n";
            String newLine = "\r\n";
            String endBoundaryStr = "\r\n" + this.boundary + "\r\n";
            totalNumberOfBytes = initialBoundaryStr.length() + contentDisposition.length() + contentType.length() + newLine.length() + endBoundaryStr.length();
            URL url1 = new URL(urlPath);
            HttpURLConnection uConn1 = (HttpURLConnection)url1.openConnection();
            uConn1.setFixedLengthStreamingMode(uploadFileLength + totalNumberOfBytes);
            uConn1.setDoOutput(true);
            uConn1.setDoInput(true);
            uConn1.setRequestProperty("MIME-version", "1.0");
            uConn1.setRequestProperty("Content-Type", "multipart/form-data;  boundary=" + this.boundary);
            uConn1.setRequestProperty("Expect", "100-continue");
            uConn1.setRequestProperty("Accept", "");
            uConn1.setRequestProperty("Cache-Control", "no-cache");
            uConn1.setRequestProperty("Content-Length", Integer.toString(uploadFileLength));
            FileInputStream inputFile = new FileInputStream(imageFile);
            DataInputStream in = new DataInputStream(inputFile);
            DataOutputStream outStream = new DataOutputStream(uConn1.getOutputStream());
            System.out.println("initial outputstream Size:" + outStream.size());
            outStream.write(initialBoundaryStr.getBytes(), 0, initialBoundaryStr.length());
            outStream.write(contentDisposition.getBytes(), 0, contentDisposition.length());
            outStream.write(contentType.getBytes(), 0, contentType.length());
            outStream.write(newLine.getBytes(), 0, newLine.length());
            int bufByte = 256;
            byte[] tempbuf = new byte[bufByte];
            while ((byteRead = in.read(tempbuf)) != -1) {
                outStream.write(tempbuf, 0, byteRead);
                System.out.println(byteRead);
            }
            outStream.write(endBoundaryStr.getBytes(), 0, endBoundaryStr.length());
            in.close();
            outStream.flush();
            outStream.close();
            System.out.println("outputstream Size:" + outStream.size());
            System.out.println(uploadFileLength);
            uConn1.disconnect();
        }
        catch (Exception uploadException) {
            System.out.println("\r\nERROR: " + uploadException.getMessage());
        }
    }

    void downloadConfig(String hostname, String httpport) {
        String downloadConfigPath = "http://" + hostname + ":" + httpport + "/protect/download/config.gce";
        String path = System.getProperty("user.dir");
        String configDirStr = path.concat("//Config");
        File configFile = new File(configDirStr);
        if (!configFile.exists()) {
            configFile.mkdir();
        }
        File[] listFile = configFile.listFiles();
        int i = 0;
        while (i < listFile.length) {
            listFile[i].delete();
            ++i;
        }
        try {
            FileOutputStream fos = null;
            try {
                URL url = new URL(downloadConfigPath);
                fos = new FileOutputStream(configDirStr.concat("//config.gce"));
                InputStream is = url.openStream();
                try {
                    int len;
                    byte[] buf = new byte[16];
                    while ((len = is.read(buf)) > 0) {
                        fos.write(buf, 0, len);
                    }
                }
                finally {
                    is.close();
                }
            }
            finally {
                fos.close();
            }
        }
        catch (IOException ex) {
            Logger.getLogger(TCPIPDiscovererTool.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    void uploadConfig(String hostname) {
        String loadconfig = "http://" + hostname + "/protect/settings/update.htm";
        URLConnection conn = null;
        DataOutputStream dos = null;
        DataInputStream inStream = null;
        String path = System.getProperty("user.dir");
        String configDirStr = path.concat("//Config//config.gce");
        String[] SplittedFileName = configDirStr.split("////");
        String exsistingFileName = SplittedFileName[SplittedFileName.length - 1];
        String lineEnd = "\r\n";
        String twoHyphens = "--";
        String boundary = "*****";
        int maxBufferSize = 0x100000;
        String urlString = loadconfig;
        try {
            FileInputStream fileInputStream = new FileInputStream(new File(configDirStr));
            URL url = new URL(urlString);
            conn = (HttpURLConnection)url.openConnection();
            conn.setDoInput(true);
            conn.setDoOutput(true);
            ((HttpURLConnection)conn).setRequestMethod("POST");
            conn.setUseCaches(false);
            conn.setRequestProperty("Connection", "Keep-Alive");
            conn.setRequestProperty("Content-Type", "multipart/form-data;boundary=" + boundary);
            dos = new DataOutputStream(conn.getOutputStream());
            dos.writeBytes(String.valueOf(twoHyphens) + boundary + lineEnd);
            dos.writeBytes("Content-Disposition: form-data; name=\"gcefile\"; filename=\"" + exsistingFileName + "\"" + lineEnd);
            dos.writeBytes(lineEnd);
            int bytesAvailable = fileInputStream.available();
            int bufferSize = Math.min(bytesAvailable, maxBufferSize);
            byte[] buffer = new byte[bufferSize];
            int bytesRead = fileInputStream.read(buffer, 0, bufferSize);
            while (bytesRead > 0) {
                dos.write(buffer, 0, bufferSize);
                bytesAvailable = fileInputStream.available();
                bufferSize = Math.min(bytesAvailable, maxBufferSize);
                bytesRead = fileInputStream.read(buffer, 0, bufferSize);
            }
            dos.writeBytes(lineEnd);
            dos.writeBytes(String.valueOf(twoHyphens) + boundary + twoHyphens + lineEnd);
            fileInputStream.close();
            dos.flush();
            dos.close();
        }
        catch (MalformedURLException ex) {
            System.out.println("Error:" + ex);
        }
        catch (IOException ioe) {
            System.out.println("Error:" + ioe);
        }
        try {
            inStream = new DataInputStream(conn.getInputStream());
            inStream.close();
        }
        catch (IOException ioex) {
            System.out.println("Error: " + ioex);
        }
    }

    void setEnableButton(boolean bool) {
        if (bool) {
            this.btnExit.setEnabled(true);
            this.btnFlash.setEnabled(true);
        } else {
            this.btnExit.setEnabled(false);
            this.btnFlash.setEnabled(false);
        }
    }

    boolean getEnableButton() {
        return this.btnFlash.isEnabled();
    }

    int CheckConfigFile() {
        File configfile = new File(System.getProperty("user.dir").concat("//Config//config.gce"));
        if (configfile.length() == 0L) {
            return -1;
        }
        if (configfile.length() < 65536L) {
            return -2;
        }
        this.isConfigDownloaded = true;
        return 0;
    }

    String getIPbyMac(String MAC) throws InterruptedException {
        int i = 0;
        int j = 0;
        String stret = null;
        String strtmp = null;
        ++this.etape;
        j = 0;
        while (j < 3) {
            this.Scanning();
            Thread.sleep(900L);
            i = 0;
            while (i < this.jTable1.getRowCount()) {
                strtmp = (String)this.jTable1.getValueAt(i, 2);
                if (MAC.equals(strtmp)) {
                    stret = (String)this.jTable1.getValueAt(i, 0);
                    System.out.println("Etape = " + this.etape);
                    System.out.println("ip = " + stret);
                    return stret;
                }
                ++i;
            }
            ++j;
        }
        System.out.println("Etape = " + this.etape);
        System.out.println("ip = " + stret);
        return stret;
    }

    String getPortbyMac(String MAC) throws InterruptedException {
        int i = 0;
        int j = 0;
        String stret = null;
        String strtmp = null;
        ++this.etape;
        j = 0;
        while (j < 3) {
            this.Scanning();
            Thread.sleep(900L);
            i = 0;
            while (i < this.jTable1.getRowCount()) {
                strtmp = (String)this.jTable1.getValueAt(i, 2);
                if (MAC.equals(strtmp)) {
                    stret = (String)this.jTable1.getValueAt(i, 3);
                    return stret;
                }
                ++i;
            }
            ++j;
        }
        return stret;
    }

    void Scanning() {
        try {
            if (!socket.isBound()) {
                socket = new DatagramSocket(30303);
                System.out.println("EthDiscoverActionPerformed:after socket");
            }
            InetAddress address = InetAddress.getByName("255.255.255.255");
            model = (DefaultTableModel)this.jTable1.getModel();
            int rowcount = model.getRowCount();
            int index1 = 0;
            while (index1 < rowcount) {
                model.removeRow(0);
                ++index1;
            }
            packet = new DatagramPacket(this.str.getBytes(), this.str.length(), address, 30303);
            socket.send(packet);
            this.jTable1.addMouseListener(null);
        }
        catch (IOException soEx) {
            String optionStr = "<html>Unable to transmit discovery message. <br> Check network connectivity and ensure that no other instances of this program are running.";
            JOptionPane.showMessageDialog(null, optionStr, "Error", 0);
            this.close_action();
        }
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    UIManager.setLookAndFeel((LookAndFeel)new WindowsLookAndFeel());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                new TCPIPDiscovererTool().setVisible(true);
            }
        });
    }
}

