/*
 * Decompiled with CFR 0.152.
 */
package oledcomm.android.fft;

public abstract class FourierTransform {
    protected static final int arraycopy = 1;
    protected static final int calcAvg = 2;
    protected static final int forward = 3;
    protected static final float freqToIndex = (float)Math.PI * 2;
    protected int Z;
    protected int getBand;
    protected float getBandWidth;
    protected float[] C;
    protected float[] B;
    protected float[] D;
    protected float[] indexToFreq;
    protected int inverse;
    protected int noAverages;
    protected int pow;

    FourierTransform(int n, float f) {
        this.Z = n;
        this.getBand = (int)f;
        this.getBandWidth = 2.0f / (float)this.Z * ((float)this.getBand / 2.0f);
        this.noAverages();
        this.I();
    }

    protected abstract void I();

    protected final void I(float[] fArray, float[] fArray2) {
        if (this.C.length == fArray.length || this.B.length == fArray2.length) {
            System.arraycopy(fArray, 0, this.C, 0, fArray.length);
            System.arraycopy(fArray2, 0, this.B, 0, fArray2.length);
        }
    }

    protected final void B() {
        block6: {
            int n;
            block5: {
                n = 0;
                while (n < this.D.length) {
                    this.D[n] = (float)Math.sqrt(this.C[n] * this.C[n] + this.B[n] * this.B[n]);
                    ++n;
                }
                if (this.inverse != 1) break block5;
                n = this.D.length / this.indexToFreq.length;
                int n2 = 0;
                while (n2 < this.indexToFreq.length) {
                    float f = 0.0f;
                    int n3 = 0;
                    while (n3 < n) {
                        int n4 = n3 + n2 * n;
                        if (n4 >= this.D.length) break;
                        f += this.D[n4];
                        ++n3;
                    }
                    this.indexToFreq[n2] = f /= (float)(n3 + 1);
                    ++n2;
                }
                break block6;
            }
            if (this.inverse != 2) break block6;
            n = 0;
            while (n < this.noAverages) {
                float f = n == 0 ? 0.0f : (float)(this.getBand / 2) / (float)Math.pow(2.0, this.noAverages - n);
                float f2 = (float)(this.getBand / 2) / (float)Math.pow(2.0, this.noAverages - n - 1);
                float f3 = (f2 - f) / (float)this.pow;
                float f4 = f;
                int n5 = 0;
                while (n5 < this.pow) {
                    int n6 = n5 + n * this.pow;
                    this.indexToFreq[n6] = this.calcAvg(f4, f4 + f3);
                    f4 += f3;
                    ++n5;
                }
                ++n;
            }
        }
    }

    public final void noAverages() {
        this.indexToFreq = new float[0];
        this.inverse = 3;
    }

    public final void linAverages(int n) {
        if (n > this.D.length / 2) {
            return;
        }
        this.indexToFreq = new float[n];
        this.inverse = 1;
    }

    public final void logAverages(int n, int n2) {
        float f = (float)this.getBand / 2.0f;
        this.noAverages = 1;
        while ((f /= 2.0f) > (float)n) {
            ++this.noAverages;
        }
        this.pow = n2;
        this.indexToFreq = new float[this.noAverages * n2];
        this.inverse = 2;
    }

    public final int timeSize() {
        return this.Z;
    }

    public final int specSize() {
        return this.D.length;
    }

    public final float getBand(int n) {
        if (n < 0) {
            n = 0;
        }
        if (n > this.D.length - 1) {
            n = this.D.length - 1;
        }
        return this.D[n];
    }

    public final float getBandWidth() {
        return this.getBandWidth;
    }

    public final float getAverageBandWidth(int n) {
        if (this.inverse == 1) {
            int n2 = this.D.length / this.indexToFreq.length;
            return (float)n2 * this.getBandWidth();
        }
        if (this.inverse == 2) {
            int n3 = n / this.pow;
            float f = n3 == 0 ? 0.0f : (float)(this.getBand / 2) / (float)Math.pow(2.0, this.noAverages - n3);
            float f2 = (float)(this.getBand / 2) / (float)Math.pow(2.0, this.noAverages - n3 - 1);
            float f3 = (f2 - f) / (float)this.pow;
            return f3;
        }
        return 0.0f;
    }

    public abstract void setBand(int var1, float var2);

    public abstract void scaleBand(int var1, float var2);

    public final int freqToIndex(float f) {
        if (f < this.getBandWidth() / 2.0f) {
            return 0;
        }
        if (f > (float)(this.getBand / 2) - this.getBandWidth() / 2.0f) {
            return this.D.length - 1;
        }
        float f2 = f / (float)this.getBand;
        int n = Math.round((float)this.Z * f2);
        return n;
    }

    public final float indexToFreq(int n) {
        float f = this.getBandWidth();
        if (n == 0) {
            return f * 0.25f;
        }
        if (n == this.D.length - 1) {
            float f2 = (float)(this.getBand / 2) - f / 2.0f;
            float f3 = f * 0.25f;
            return f2 + f3;
        }
        return (float)n * f;
    }

    public final float getAverageCenterFrequency(int n) {
        if (this.inverse == 1) {
            int n2 = this.D.length / this.indexToFreq.length;
            int n3 = n * n2 + n2 / 2;
            return this.indexToFreq(n3);
        }
        if (this.inverse == 2) {
            int n4 = n / this.pow;
            int n5 = n % this.pow;
            float f = n4 == 0 ? 0.0f : (float)(this.getBand / 2) / (float)Math.pow(2.0, this.noAverages - n4);
            float f2 = (float)(this.getBand / 2) / (float)Math.pow(2.0, this.noAverages - n4 - 1);
            float f3 = (f2 - f) / (float)this.pow;
            float f4 = f + (float)n5 * f3;
            return f4 + f3 / 2.0f;
        }
        return 0.0f;
    }

    public final float getFreq(float f) {
        return this.getBand(this.freqToIndex(f));
    }

    public final void setFreq(float f, float f2) {
        this.setBand(this.freqToIndex(f), f2);
    }

    public final void scaleFreq(float f, float f2) {
        this.scaleBand(this.freqToIndex(f), f2);
    }

    public final int avgSize() {
        return this.indexToFreq.length;
    }

    public final float getAvg(int n) {
        float f = this.indexToFreq.length > 0 ? this.indexToFreq[n] : 0.0f;
        return f;
    }

    public final float calcAvg(float f, float f2) {
        int n = this.freqToIndex(f);
        int n2 = this.freqToIndex(f2);
        float f3 = 0.0f;
        int n3 = n;
        while (n3 <= n2) {
            f3 += this.D[n3];
            ++n3;
        }
        return f3 /= (float)(n2 - n + 1);
    }

    public final float[] getSpectrumReal() {
        return this.C;
    }

    public final float[] getSpectrumImaginary() {
        return this.B;
    }

    public abstract void forward(float[] var1);

    public void forward(float[] fArray, int n) {
        if (fArray.length - n < this.Z) {
            return;
        }
        float[] fArray2 = new float[this.Z];
        System.arraycopy(fArray, n, fArray2, 0, fArray2.length);
        this.forward(fArray2);
    }

    public abstract void inverse(float[] var1);

    public final void inverse(float[] fArray, float[] fArray2, float[] fArray3) {
        this.I(fArray, fArray2);
        this.inverse(fArray3);
    }
}

