/*
 * Decompiled with CFR 0.152.
 */
package oledcomm.android.fft;

import I.I;
import oledcomm.android.fft.FourierTransform;

public class FFT
extends FourierTransform {
    public static final int ACCURACY_LOW = 512;
    public static final int ACCURACY_MIDEUM = 1024;
    public static final int ACCURACY_HIGH = 2048;
    private int[] I;
    private float[] cos;
    private float[] sin;

    public FFT(int n, float f) {
        super(n, f);
        if ((n & n - 1) != 0) {
            throw new IllegalArgumentException(I.I.I(50));
        }
        this.sin();
        this.C();
    }

    @Override
    protected final void I() {
        this.D = new float[this.Z / 2 + 1];
        this.C = new float[this.Z];
        this.B = new float[this.Z];
    }

    @Override
    public final void scaleBand(int n, float f) {
        if (f < 0.0f) {
            return;
        }
        int n2 = n;
        this.C[n2] = this.C[n2] * f;
        int n3 = n;
        this.B[n3] = this.B[n3] * f;
        int n4 = n;
        this.D[n4] = this.D[n4] * f;
        if (n != 0 && n != this.Z / 2) {
            this.C[this.Z - n] = this.C[n];
            this.B[this.Z - n] = -this.B[n];
        }
    }

    @Override
    public final void setBand(int n, float f) {
        if (f < 0.0f) {
            return;
        }
        if (this.C[n] == 0.0f && this.B[n] == 0.0f) {
            this.C[n] = f;
            this.D[n] = f;
        } else {
            int n2 = n;
            this.C[n2] = this.C[n2] / this.D[n];
            int n3 = n;
            this.B[n3] = this.B[n3] / this.D[n];
            this.D[n] = f;
            int n4 = n;
            this.C[n4] = this.C[n4] * this.D[n];
            int n5 = n;
            this.B[n5] = this.B[n5] * this.D[n];
        }
        if (n != 0 && n != this.Z / 2) {
            this.C[this.Z - n] = this.C[n];
            this.B[this.Z - n] = -this.B[n];
        }
    }

    private void cos() {
        int n = 1;
        while (n < this.C.length) {
            float f = this.Z(n);
            float f2 = this.I(n);
            float f3 = 1.0f;
            float f4 = 0.0f;
            int n2 = 0;
            while (n2 < n) {
                int n3 = n2;
                while (n3 < this.C.length) {
                    int n4 = n3 + n;
                    float f5 = f3 * this.C[n4] - f4 * this.B[n4];
                    float f6 = f3 * this.B[n4] + f4 * this.C[n4];
                    this.C[n4] = this.C[n3] - f5;
                    this.B[n4] = this.B[n3] - f6;
                    int n5 = n3;
                    this.C[n5] = this.C[n5] + f5;
                    int n6 = n3;
                    this.B[n6] = this.B[n6] + f6;
                    n3 += 2 * n;
                }
                float f7 = f3;
                f3 = f7 * f - f4 * f2;
                f4 = f7 * f2 + f4 * f;
                ++n2;
            }
            n *= 2;
        }
    }

    @Override
    public final void forward(float[] fArray) {
        if (fArray.length != this.Z) {
            return;
        }
        this.I(fArray, 0);
        this.cos();
        this.B();
    }

    @Override
    public final void forward(float[] fArray, int n) {
        if (fArray.length - n < this.Z) {
            return;
        }
        this.I(fArray, n);
        this.cos();
        this.B();
    }

    public final void forward(float[] fArray, float[] fArray2) {
        if (fArray.length != this.Z || fArray2.length != this.Z) {
            return;
        }
        this.I(fArray, fArray2);
        this.Z();
        this.cos();
        this.B();
    }

    @Override
    public final void inverse(float[] fArray) {
        if (fArray.length > this.C.length) {
            return;
        }
        int n = 0;
        while (n < this.Z) {
            int n2 = n++;
            this.B[n2] = this.B[n2] * -1.0f;
        }
        this.Z();
        this.cos();
        n = 0;
        while (n < fArray.length) {
            fArray[n] = this.C[n] / (float)this.C.length;
            ++n;
        }
    }

    private void sin() {
        int n = this.Z;
        this.I = new int[n];
        this.I[0] = 0;
        int n2 = 1;
        int n3 = n / 2;
        while (n2 < n) {
            int n4 = 0;
            while (n4 < n2) {
                this.I[n4 + n2] = this.I[n4] + n3;
                ++n4;
            }
            n2 <<= 1;
            n3 >>= 1;
        }
    }

    private void I(float[] fArray, int n) {
        int n2 = 0;
        while (n2 < this.Z) {
            this.C[n2] = fArray[n + this.I[n2]];
            this.B[n2] = 0.0f;
            ++n2;
        }
    }

    private void Z() {
        float[] fArray = new float[this.C.length];
        float[] fArray2 = new float[this.B.length];
        int n = 0;
        while (n < this.C.length) {
            fArray[n] = this.C[this.I[n]];
            fArray2[n] = this.B[this.I[n]];
            ++n;
        }
        this.C = fArray;
        this.B = fArray2;
    }

    private float I(int n) {
        return this.cos[n];
    }

    private float Z(int n) {
        return this.sin[n];
    }

    private void C() {
        int n = this.Z;
        this.cos = new float[n];
        this.sin = new float[n];
        int n2 = 0;
        while (n2 < n) {
            this.cos[n2] = (float)Math.sin((float)(-Math.PI) / (float)n2);
            this.sin[n2] = (float)Math.cos((float)(-Math.PI) / (float)n2);
            ++n2;
        }
    }
}

