/*
 * Decompiled with CFR 0.152.
 */
package oledcomm.android.fft;

public abstract class FourierTransform {
    protected int a;
    protected int b;
    protected float c;
    protected float[] d;
    protected float[] e;
    protected float[] f;
    protected float[] g;
    protected int h;
    protected int i;
    protected int j;

    FourierTransform(int n, float f) {
        this.a = n;
        this.b = (int)f;
        this.c = 2.0f / (float)this.a * ((float)this.b / 2.0f);
        this.noAverages();
        this.a();
    }

    protected abstract void a();

    protected void a(float[] fArray, float[] fArray2) {
        if (this.d.length == fArray.length || this.e.length == fArray2.length) {
            System.arraycopy(fArray, 0, this.d, 0, fArray.length);
            System.arraycopy(fArray2, 0, this.e, 0, fArray2.length);
        }
    }

    protected void b() {
        block6: {
            int n;
            block5: {
                for (n = 0; n < this.f.length; ++n) {
                    this.f[n] = (float)Math.sqrt(this.d[n] * this.d[n] + this.e[n] * this.e[n]);
                }
                if (this.h != 1) break block5;
                n = this.f.length / this.g.length;
                for (int i = 0; i < this.g.length; ++i) {
                    int n2;
                    int n3;
                    float f = 0.0f;
                    for (n3 = 0; n3 < n && (n2 = n3 + i * n) < this.f.length; ++n3) {
                        f += this.f[n2];
                    }
                    this.g[i] = f /= (float)(n3 + 1);
                }
                break block6;
            }
            if (this.h != 2) break block6;
            for (n = 0; n < this.i; ++n) {
                float f = n == 0 ? 0.0f : (float)(this.b / 2) / (float)Math.pow(2.0, this.i - n);
                float f2 = (float)(this.b / 2) / (float)Math.pow(2.0, this.i - n - 1);
                float f3 = (f2 - f) / (float)this.j;
                float f4 = f;
                for (int i = 0; i < this.j; ++i) {
                    int n4 = i + n * this.j;
                    this.g[n4] = this.calcAvg(f4, f4 + f3);
                    f4 += f3;
                }
            }
        }
    }

    public void noAverages() {
        this.g = new float[0];
        this.h = 3;
    }

    public void linAverages(int n) {
        if (n > this.f.length / 2) {
            return;
        }
        this.g = new float[n];
        this.h = 1;
    }

    public void logAverages(int n, int n2) {
        float f = (float)this.b / 2.0f;
        this.i = 1;
        while (true) {
            float f2;
            f /= 2.0f;
            if (!(f2 > (float)n)) break;
            ++this.i;
        }
        this.j = n2;
        this.g = new float[this.i * n2];
        this.h = 2;
    }

    public int timeSize() {
        return this.a;
    }

    public int specSize() {
        return this.f.length;
    }

    public float getBand(int n) {
        if (n < 0) {
            n = 0;
        }
        if (n > this.f.length - 1) {
            n = this.f.length - 1;
        }
        return this.f[n];
    }

    public float getBandWidth() {
        return this.c;
    }

    public float getAverageBandWidth(int n) {
        if (this.h == 1) {
            int n2 = this.f.length / this.g.length;
            return (float)n2 * this.getBandWidth();
        }
        if (this.h == 2) {
            int n3 = n / this.j;
            float f = n3 == 0 ? 0.0f : (float)(this.b / 2) / (float)Math.pow(2.0, this.i - n3);
            float f2 = (float)(this.b / 2) / (float)Math.pow(2.0, this.i - n3 - 1);
            float f3 = (f2 - f) / (float)this.j;
            return f3;
        }
        return 0.0f;
    }

    public abstract void setBand(int var1, float var2);

    public abstract void scaleBand(int var1, float var2);

    public int freqToIndex(float f) {
        if (f < this.getBandWidth() / 2.0f) {
            return 0;
        }
        if (f > (float)(this.b / 2) - this.getBandWidth() / 2.0f) {
            return this.f.length - 1;
        }
        float f2 = f / (float)this.b;
        int n = Math.round((float)this.a * f2);
        return n;
    }

    public float indexToFreq(int n) {
        float f = this.getBandWidth();
        if (n == 0) {
            return f * 0.25f;
        }
        if (n == this.f.length - 1) {
            float f2 = (float)(this.b / 2) - f / 2.0f;
            float f3 = f * 0.25f;
            return f2 + f3;
        }
        return (float)n * f;
    }

    public float getAverageCenterFrequency(int n) {
        if (this.h == 1) {
            int n2 = this.f.length / this.g.length;
            int n3 = n * n2 + n2 / 2;
            return this.indexToFreq(n3);
        }
        if (this.h == 2) {
            int n4 = n / this.j;
            int n5 = n % this.j;
            float f = n4 == 0 ? 0.0f : (float)(this.b / 2) / (float)Math.pow(2.0, this.i - n4);
            float f2 = (float)(this.b / 2) / (float)Math.pow(2.0, this.i - n4 - 1);
            float f3 = (f2 - f) / (float)this.j;
            float f4 = f + (float)n5 * f3;
            return f4 + f3 / 2.0f;
        }
        return 0.0f;
    }

    public float getFreq(float f) {
        return this.getBand(this.freqToIndex(f));
    }

    public void setFreq(float f, float f2) {
        this.setBand(this.freqToIndex(f), f2);
    }

    public void scaleFreq(float f, float f2) {
        this.scaleBand(this.freqToIndex(f), f2);
    }

    public int avgSize() {
        return this.g.length;
    }

    public float getAvg(int n) {
        float f = this.g.length > 0 ? this.g[n] : 0.0f;
        return f;
    }

    public float calcAvg(float f, float f2) {
        int n = this.freqToIndex(f);
        int n2 = this.freqToIndex(f2);
        float f3 = 0.0f;
        for (int i = n; i <= n2; ++i) {
            f3 += this.f[i];
        }
        return f3 /= (float)(n2 - n + 1);
    }

    public float[] getSpectrumReal() {
        return this.d;
    }

    public float[] getSpectrumImaginary() {
        return this.e;
    }

    public abstract void forward(float[] var1);

    public void forward(float[] fArray, int n) {
        if (fArray.length - n < this.a) {
            return;
        }
        float[] fArray2 = new float[this.a];
        System.arraycopy(fArray, n, fArray2, 0, fArray2.length);
        this.forward(fArray2);
    }

    public abstract void inverse(float[] var1);

    public void inverse(float[] fArray, float[] fArray2, float[] fArray3) {
        this.a(fArray, fArray2);
        this.inverse(fArray3);
    }
}

